// The Project Dialect

// opinclude the default opC++ dialect:
// opinclude "opC++Dialect.doh"

// Specify custom dialect settings below:

category myclass
{
	/*=== no const volatile ===*/

	disallow noconstvolatile
	{
		is data_statement;
		is const;
		is volatile;
	}

	/*=== capitalize variables ===*/

	error("Variable names must begin with capital letters.")
	disallow capitalizevariables
	{
		is data_statement;
		is not member_name("[A-Z].*");
	}

	/*=== only log strings ===*/

	datamodifier log;

	error("Only strings can be logged.")
	disallow onlylogstrings
	{
		is data_statement;
		is not data_type("string");
		is log;
	}

	/*=== xml value must be an alphabetic string ===*/

	error("xml value must be an alphabetic string.") datamodifier xml("[A-Za-z]+");
};