// The Project Dialect

// opinclude the default opC++ dialect:
// opinclude "opC++Dialect.doh"

// Specify custom dialect settings below:

#include <iostream>
#include <map>
#include <string>

using namespace std;

category codec
{
	/*=== log ===*/

	datamodifier log;

	location body
	{
		datamap logdatamembers
		{
			is log;
		}
	}

	/*=== xml ===*/

	datamodifier xml();

	location body
	{
		datamap printxml
		{
			is xml();
		}
	}

	/*=== events ===*/

	functionmodifier event;

	location body
	{
		note defaultconstructor;
		note eventmap;

 		functionmap buildeventmap
 		{
			is event;
			is function_signature("void \(\)");
 		}

		note callevent;
	}
};

/*=== log ===*/

note codec::body::logdatamembers::start()
{
public:

	// Method to log all data members.
	void Log()
	+{}
}

note codec::body::logdatamembers::mapping(member_name)
{
		cout << ``member_name`` << " = " << member_name << endl;
}

note codec::body::logdatamembers::end()
{
	-{}
}

/*=== xml ===*/

note codec::body::printxml::start()
{
public:

	void PrintXml()
	+{}
}

note codec::body::printxml::mapping(member_name, xml)
{
		cout << "<" << ``xml`` << ">" << member_name << "<" << ``xml`` << "/>" << endl;}

note codec::body::printxml::end()
{
	-{}
}

/*=== events ===*/

// defaultconstructor

note codec::body::defaultconstructor(class_name)
{
public:

	class_name()
	{
		BuildEventMap();
	}
}

// eventmap

note codec::body::eventmap(class_name)
{
private:

	map<string, void (class_name::*)()> Events;
}

// buildeventmap

note codec::body::buildeventmap::start()
{
private:

	void BuildEventMap()
	+{}
}

note codec::body::buildeventmap::mapping(class_name, member_name)
{
		Events[``member_name``] = &class_name::member_name;
}

note codec::body::buildeventmap::end()
{
	-{}
}

// callevent

note codec::body::callevent(class_name)
{
public:

	// This method allows you to call an event
	// by its string name.
	bool CallEvent(const string& event)
	{
		map<string, void (class_name::*)()>::iterator i;

		i = Events.find(event);

		// If the event exists, call it.
		if (i != Events.end())
		{
			void (class_name::*Ptr)() = Events[event];

			// Call the event.
			(this->*Ptr)();

			return true;
		}

		return false;
	}
}



