// The Project Dialect

// opinclude the default opC++ dialect:
// opinclude "opC++Dialect.doh"

// Specify custom dialect settings below:

#define  NULL 0
#include <iostream>

using namespace std;

category fruit
{
	/*=== generateconstructor ===*/

	location body
	{
		note generateconstructor
		{
			// is A and not (B or C);
			is not category_simple_constructor;
		}
	}

	/*=== printpointers ===*/

	location body
	{
		datamap printpointers
		{
			is data_pointer;
		}
	}

	/*=== zeropointers ===*/

	location body
	{
		datamap zeropointers
		{
			is data_pointer;
		}
	}

	/*=== printnumerictypes ===*/

	location body
	{
		datamap printnumerictypes
		{
			is data_type("float|int|double");
		}
	}
};

/*=== generateconstructor ===*/

note fruit::body::generateconstructor(class_name)
{
public:

	class_name()
	{

	}
}

/*=== printpointers ===*/

note fruit::body::printpointers::start()
{
public:

	void PrintPointers()
	+{}
}

note fruit::body::printpointers::mapping(member_name)
{
		cout << ``member_name`` << " = " << member_name << endl;
}

note fruit::body::printpointers::end()
{
	-{}
}

/*=== zeropointers ===*/

note fruit::body::zeropointers::start()
{
public:

	void ZeroPointers()
	+{}
}

note fruit::body::zeropointers::mapping(member_name)
{
		member_name = NULL;
}

note fruit::body::zeropointers::end()
{
	-{}
}

/*=== printnumerictypes ===*/

note fruit::body::printnumerictypes::start()
{
public:

	void PrintNumericTypes()
	+{}
}

note fruit::body::printnumerictypes::mapping(member_name)
{
		cout << ``member_name`` << endl;
}

note fruit::body::printnumerictypes::end()
{
	-{}
}