#include "main.h"

// Include the generated source index.
// NOTE: Keep the project name and this path in sync.
#include "Generated/InstanceReflection/Generated.ocppindex"
#include <conio.h>

// Entry point into the application.
int main()
{
	using opcpp::registration::class_type;
	using opcpp::fields::data_field;

	ProgrammingLanguage pl;

	// Search for a specific data member.
	class_type& type  = pl.get_type();
	data_field* field = type.get_field("SupportsReflection");

	if (field)
	{
		cout << "opclass '" << type.get_name() << "' has a field '" 
		     << field->member_name() << "'" << endl << endl;
	}

	// Modify an opclass via reflection.
	cout << "Keywords\n--------\n";
	pl.PrintKeywords();
	cout << endl;

	field = type.get_field("Keywords");
	
	if ( field )
	{
		vector< string >* keywords = field->get_value< vector<string> >( pl );
		
		if ( keywords )
		{
			keywords->push_back("if");
			keywords->push_back("then");
			keywords->push_back("else");	
		}
	}

	cout << "Keywords\n--------\n";
	pl.PrintKeywords();

	_getch();
	
	return 0;
}